let currentPage = 1;
const rowsPerPage = 5;

function displayTable() {
  const tableRows = document.querySelectorAll("tbody tr");
  const totalRows = tableRows.length;
  const totalPages = Math.ceil(totalRows / rowsPerPage);

  // Show/Hide Rows
  tableRows.forEach((row, index) => {
    row.style.display =
      index >= (currentPage - 1) * rowsPerPage && index < currentPage * rowsPerPage
        ? ""
        : "none";
  });

  // Agar rows kam hain ya barabar hain rowsPerPage ke, pagination hide kar do
  if (totalRows <= rowsPerPage) {
    document.querySelector(".pagination").style.display = "none";
  } else {
    document.querySelector(".pagination").style.display = "block";
    generatePagination(totalPages);
  }
}

function generatePagination(totalPages) {
  const paginationNumbers = document.getElementById("paginationNumbers");
  paginationNumbers.innerHTML = "";

  for (let i = 1; i <= totalPages; i++) {
    const btn = document.createElement("button");
    btn.textContent = i;
    btn.className = i === currentPage ? "active" : "";
    btn.addEventListener("click", () => {
      currentPage = i;
      displayTable();
    });
    paginationNumbers.appendChild(btn);
  }
}

function nextPage() {
  const totalRows = document.querySelectorAll("tbody tr").length;
  const totalPages = Math.ceil(totalRows / rowsPerPage);
  if (currentPage < totalPages) {
    currentPage++;
    displayTable();
  }
}

function prevPage() {
  if (currentPage > 1) {
    currentPage--;
    displayTable();
  }
}

// ----- MODAL LOGIC -----
const modal = document.getElementById("updateModal");

function openModal() {
  modal.style.display = "flex";
  document.querySelector(".container").classList.add("blur");
}

function closeModal() {
  modal.style.display = "none";
  document.querySelector(".container").classList.remove("blur");
}

modal.addEventListener("click", function (e) {
  if (e.target === modal) closeModal();
});

// Call first time to display
displayTable();
