<?php

namespace App\Http\Controllers;

use App\Models\Customer;
use App\Models\Restaurant;
use App\Models\GenerateUrl;
use Illuminate\Support\Str;
use Illuminate\Http\Request;

class CustomerController extends Controller
{

    // public function viewCustomer()
    // {
    //     $customers = Customer::latest()->take(100)->paginate(15);
    //     return view('customer-view', compact('customers'));
    // }

    public function store(Request $request)
    {
        try {
            $request->validate([
                'name' => 'required',
                'email' => 'required|email|unique:customers,email',
                'phone' => 'required|unique:customers,phone',
                'restaurant_id' => 'required',
                'token' => 'required|unique:customers,phone',
                'privacy_policy' => 'accepted',
                'terms' => 'accepted',
            ]);



            $customer =Customer::create([
                'name' => $request['name'],
                'token' => $request['token'],
                'email' => $request['email'],
                'phone' => $request['phone'],
                'location' => $request['location'],

                'restaurant_id' => $request['restaurant_id'],
                'privacy_policy' => $request->has('privacy_policy') ? 1 : 0,
                'terms' => $request->has('terms') ? 1 : 0,
            ]);


            session([
                'customer_id'    => $customer->id,
                'customer_name'  => $customer->name,
                'customer_email' => $customer->email,
                'customer_phone' => $customer->phone,
            ]);

                return redirect()->route('thank.you', ['token' => $request['token']]);
        } catch (Exception $exp) {
            return redirect()->back()->with('error', $exp->getMessage());
        }
    }

    public function thankYou(Request $request)
    {
        $token = $request->get('token');
        if($token){
            $generateUrl= GenerateUrl::with('restaurant')->where('token', $token)->first();
            $imagePath= $generateUrl->restaurant->image;
            return view('thank-you', compact('imagePath'));
        } else {
            return view('thank-you');
        }
    }

    public function searchCustomer(Request $request)
    {
        $query = $request->get('query');

        $customers = Customer::when($query, function($q) use ($query) {
            $q->where('name', 'like', "%{$query}%")
              ->orWhere('phone', 'like', "%{$query}%");
        })->latest()->paginate(15);

        if ($request->ajax()) {
            return view('customer.table', compact('customers'))->render();
        }
        return view('customer.customer-view', compact('customers'));
    }
    
    public function selectWinner($restaurant_id)
    {
        $restaurant = Restaurant::find($restaurant_id);

        if (!$restaurant) {
            return response()->json(['error' => 'Restaurant not found'], 404);
        }
    

        $customers = $restaurant->customer->where('is_winner', 0);
        
    
        if ($customers->isEmpty()) {
            return response()->json(['error' => 'No customers found'], 404);
        }

        $winner = $customers->random();
        $winner->update(['is_winner' => '1']);
    
        return response()->json([
            'winner' => $winner
        ]);
    }

    public function getWinners($restaurant_id)
    {
        $restaurant= Restaurant::find($restaurant_id);
        $winners= $restaurant->customer->where('is_winner', 1);
        return response()->json([
            'winners' => $winners
        ]);
    }


}


