<?php $__env->startSection('content'); ?>
<div class="container mt-5">
    <div class="row">
        <div class="col-md-12">

            <div class="card shadow-sm">
                <div class="card-header bg-primary text-white d-flex justify-content-between align-items-center">
                    <h4>Restaurant List</h4>
                    <a href="<?php echo e(route('restaurants.create')); ?>" class="btn btn-light btn-sm">Add Restaurant</a>
                </div>

                <div class="card-body">
                    <?php if(session('success')): ?>
                        <div class="alert alert-success"><?php echo e(session('success')); ?></div>
                    <?php endif; ?>

                    <?php if(isset($restaurants) && $restaurants->count() > 0): ?>
                        <table class="table table-bordered table-striped">
                            <thead class="table-light">
                                <tr>
                                    <th>#</th>
                                    <th>Name</th>
                                    <th>Email</th>
                                    <th>Address</th>
                                    <th>Website</th>
                                    <th>Created At</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $restaurants; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $restaurant): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td><?php echo e($loop->iteration); ?></td>
                                        <td><?php echo e($restaurant->user->name ?? '-'); ?></td>
                                        <td><?php echo e($restaurant->user->email ?? '-'); ?></td>
                                        <td><?php echo e($restaurant->address ?? '-'); ?></td>
                                        <td><?php echo e($restaurant->website ?? '-'); ?></td>
                                        <td><?php echo e($restaurant->created_at->format('d M Y')); ?></td>
                                        <td>
                                            <div class="dropdown">
                                                <button class="btn btn-secondary btn-sm dropdown-toggle" type="button" id="actionDropdown<?php echo e($restaurant->id); ?>" data-bs-toggle="dropdown" aria-expanded="false">
                                                    Actions
                                                </button>
                                                <ul class="dropdown-menu" aria-labelledby="actionDropdown<?php echo e($restaurant->id); ?>">
                                                    <li>
                                                        <a class="dropdown-item" href="<?php echo e(route('restaurants.edit', $restaurant->id)); ?>">Edit</a>
                                                    </li>
                                                    <li>
                                                        <form action="<?php echo e(route('restaurants.destroy', $restaurant->id)); ?>" method="POST" onsubmit="return confirm('Are you sure you want to delete this restaurant?');">
                                                            <?php echo csrf_field(); ?>
                                                            <?php echo method_field('DELETE'); ?>
                                                            <button class="dropdown-item text-danger" type="submit">Delete</button>
                                                        </form>
                                                    </li>
                                                </ul>
                                            </div>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    <?php else: ?>
                        <p class="text-center">No restaurants found!</p>
                    <?php endif; ?>
                </div>
            </div>

        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\wamp64\www\public_html\resources\views/restaurant/index.blade.php ENDPATH**/ ?>