<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\URLController;
use App\Http\Controllers\HomeController;
use App\Http\Controllers\CustomerController;
use App\Http\Controllers\RestaurantController;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "web" middleware group. Make something great!
|
*/

Route::get('/', function () {
    return redirect()->route('login');
});


Auth::routes();

// Route::get('/home', [HomeController::class, 'index'])->name('home');
Route::middleware('auth')->group(function () {
    Route::get('/home', function(){
        return redirect('/restaurants');
    })->name('home');
    Route::resource('/restaurants', RestaurantController::class);
    Route::post('/customer', [CustomerController::class, 'store']);
    Route::get('/customers/search', [CustomerController::class, 'searchCustomer'])->name('customers.search');
    Route::get('/customers', [CustomerController::class, 'index'])->name('customers.index');
});

Route::get('customer/{restuarent_id}/{token}', [URLController::class, 'create']);
Route::get('/thank-you', [CustomerController::class, 'thankYou'])->name('thank.you');
// Route::get('/get-customers', [CustomerController::class, 'viewCustomer']);



